/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;

public class ToolBuildingRecipeSerializer
extends LoggingRecipeSerializer<ToolBuildingRecipe> {
    public ToolBuildingRecipe fromJson(class_2960 recipeId, JsonObject json) {
        String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
        IModifiable item = RecipeHelper.deserializeItem(class_3518.method_15265((JsonObject)json, (String)"result"), "result", IModifiable.class);
        if (!item.getToolDefinition().isMultipart()) {
            throw new JsonSyntaxException("Modifiable item must have tool parts to get a tool building recipe");
        }
        int resultCount = class_3518.method_15282((JsonObject)json, (String)"result_count", (int)1);
        List<class_1856> extraRequirements = Collections.emptyList();
        if (json.has("extra_requirements")) {
            extraRequirements = JsonHelper.parseList(json, "extra_requirements", jsonObject -> class_1856.method_52177((JsonElement)jsonObject));
        }
        return new ToolBuildingRecipe(recipeId, group, item, resultCount, extraRequirements);
    }

    @Override
    @Nullable
    protected ToolBuildingRecipe fromNetworkSafe(class_2960 recipeId, class_2540 buffer) {
        String group = buffer.method_10800(Short.MAX_VALUE);
        IModifiable result = RecipeHelper.readItem(buffer, IModifiable.class);
        int resultSize = buffer.method_10816();
        int size = buffer.method_10816();
        ImmutableList.Builder ingredients = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Object)class_1856.method_8086((class_2540)buffer));
        }
        return new ToolBuildingRecipe(recipeId, group, result, resultSize, (List<class_1856>)ingredients.build());
    }

    @Override
    protected void toNetworkSafe(class_2540 buffer, ToolBuildingRecipe recipe) {
        buffer.method_10814(recipe.group);
        RecipeHelper.writeItem(buffer, recipe.output);
        buffer.method_10804(recipe.outputCount);
        buffer.method_10804(recipe.ingredients.size());
        for (class_1856 ingredient : recipe.ingredients) {
            ingredient.method_8088(buffer);
        }
    }
}

